Tiled_Shape_Ellipse = Core.class(Sprite)

function Tiled_Shape_Ellipse:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or 0
	params.h = xparams.h or 0
	params.steps = xparams.steps or 32 -- 24
	params.shapelinewidth = xparams.shapelinewidth or nil
	params.shapelinecolor = xparams.shapelinecolor or nil
	params.shapelinealpha = xparams.shapelinealpha or 1
	params.color = xparams.color or nil
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.texpath = xparams.texpath or nil
	params.istexpot = xparams.istexpot or nil
	params.scalex = xparams.scalex or 1
	params.scaley = xparams.scaley or params.scalex
	params.skewx = xparams.skewx or 0 -- angle in degrees
	params.skewy = xparams.skewy or params.skewx -- angle in degrees
	params.rotation = xparams.rotation or 0
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = Shape.new()
	if params.shapelinewidth then
		img:setLineStyle(params.shapelinewidth, params.shapelinecolor, params.shapelinealpha)
	end
	if params.texpath then
		local tex
		if not params.istexpot then
			tex = Texture.new(params.texpath, false, { wrap = Texture.REPEAT, extend = false, } )
		else
			tex = Texture.new(params.texpath, false, { wrap = Texture.REPEAT, } )
		end
		local skewanglex = math.rad(params.skewx)
		local skewangley = math.rad(params.skewy)
		local matrix = Matrix.new(
			params.scalex, math.tan(skewanglex), math.tan(skewangley), params.scaley, 0, 0
		)
		img:setFillStyle(Shape.TEXTURE, tex, matrix)
		tex = nil
	elseif params.color then
		img:setFillStyle(Shape.SOLID, params.color, params.alpha)
	else
		img:setFillStyle(Shape.NONE)
	end
	img:beginPath()
	for i = 0, 360, 360 / params.steps  do
		img:lineTo(
			(params.w / 2) + params.w / 2 * math.cos(^<i),
			(params.h / 2) + params.h / 2 * math.sin(^<i)
		)
	end
	img:closePath()
	img:endPath()
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end

Tiled_Shape_Point = Core.class(Sprite)

function Tiled_Shape_Point:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or 0
	params.h = xparams.h or 0
	params.shapelinewidth = xparams.shapelinewidth or 1
	params.shapelinecolor = xparams.shapelinecolor or nil
	params.shapelinealpha = xparams.shapelinealpha or 1
	params.color = xparams.color or nil -- hex
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.rotation = xparams.rotation or 0
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = Shape.new()
	img:setLineStyle(params.shapelinewidth, params.shapelinecolor, params.shapelinealpha)
	img:beginPath()
	img:moveTo(0,0)
	img:lineTo(1, 0)
	img:endPath()
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end

Tiled_Shape_Polygon = Core.class(Sprite)

function Tiled_Shape_Polygon:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or 0
	params.h = xparams.h or 0
	params.coords = xparams.coords or nil
	params.shapelinewidth = xparams.shapelinewidth or nil
	params.shapelinecolor = xparams.shapelinecolor or nil
	params.shapelinealpha = xparams.shapelinealpha or 1
	params.color = xparams.color or nil -- hex
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.texpath = xparams.texpath or nil
	params.istexpot = xparams.istexpot or nil
	params.scalex = xparams.scalex or 1
	params.scaley = xparams.scaley or params.scalex
	params.skewx = xparams.skewx or 0 -- angle in degrees
	params.skewy = xparams.skewy or params.skewx -- angle in degrees
	params.rotation = xparams.rotation or 0
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = Shape.new()
	if params.shapelinewidth then
		img:setLineStyle(params.shapelinewidth, params.shapelinecolor, params.shapelinealpha)
	end
	if params.texpath then
		local tex
		if not params.istexpot then
			tex = Texture.new(params.texpath, false, { wrap = Texture.REPEAT, extend = false, } )
		else
			tex = Texture.new(params.texpath, false, { wrap = Texture.REPEAT, } )
		end
		local skewanglex = math.rad(params.skewx)
		local skewangley = math.rad(params.skewy)
		local matrix = Matrix.new(
			params.scalex, math.tan(skewanglex), math.tan(skewangley), params.scaley, 0, 0
		)
		img:setFillStyle(Shape.TEXTURE, tex, matrix)
		tex = nil
	elseif params.color then
		img:setFillStyle(Shape.SOLID, params.color, params.alpha)
	else
		img:setFillStyle(Shape.NONE)
	end
	img:beginPath()
	img:moveTo(params.coords[1].x, params.coords[1].y)
	for p = 2, #params.coords do
		img:lineTo(params.coords[p].x, params.coords[p].y)
	end
	img:closePath()
	img:endPath()
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end

Tiled_Shape_Polyline = Core.class(Sprite)

function Tiled_Shape_Polyline:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or 0
	params.h = xparams.h or 0
	params.coords = xparams.coords or nil
	params.shapelinewidth = xparams.shapelinewidth or 1
	params.shapelinecolor = xparams.shapelinecolor or nil
	params.shapelinealpha = xparams.shapelinealpha or 1
	params.color = xparams.color or nil -- hex
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.rotation = xparams.rotation or 0
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = Shape.new()
	img:setLineStyle(params.shapelinewidth, params.shapelinecolor, params.shapelinealpha)
	img:setFillStyle(Shape.NONE)
	img:beginPath()
	img:moveTo(params.coords[1].x, params.coords[1].y)
	for p = 2, #params.coords do
		img:lineTo(params.coords[p].x, params.coords[p].y)
	end
--	img:closePath()
	img:endPath()
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end

Tiled_Shape_Rectangle = Core.class(Sprite)

function Tiled_Shape_Rectangle:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.shapelinewidth = xparams.shapelinewidth or 0
	params.shapelinecolor = xparams.shapelinecolor or nil
	params.shapelinealpha = xparams.shapelinealpha or 1
	params.color = xparams.color or nil -- hex
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.texpath = xparams.texpath or nil
	params.istexpot = xparams.istexpot or nil
	params.scalex = xparams.scalex or 1
	params.scaley = xparams.scaley or params.scalex
	params.skewx = xparams.skewx or 0 -- angle in degrees
	params.skewy = xparams.skewy or params.skewx -- angle in degrees
	params.rotation = xparams.rotation or nil
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = Shape.new()
	img:setLineStyle(params.shapelinewidth, params.shapelinecolor, params.shapelinealpha)
	if params.texpath then
		local tex
		if not params.istexpot then
			tex = Texture.new(params.texpath, false, { wrap = Texture.REPEAT, extend = false, } )
		else
			tex = Texture.new(params.texpath, false, { wrap=Texture.REPEAT, } )
		end
		local skewanglex = math.rad(params.skewx)
		local skewangley = math.rad(params.skewy)
		local matrix = Matrix.new(
			params.scalex, math.tan(skewanglex), math.tan(skewangley), params.scaley, 0, 0
		)
		img:setFillStyle(Shape.TEXTURE, tex, matrix)
		tex = nil
	elseif params.color then
		img:setFillStyle(Shape.SOLID, params.color, params.alpha)
	else
		img:setFillStyle(Shape.NONE)
	end
	img:beginPath()
	img:moveTo(0, 0)
	img:lineTo(params.w, 0)
	img:lineTo(params.w, params.h)
	img:lineTo(0, params.h)
	img:lineTo(0, 0)
	img:endPath()
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end

Tiled_Shape_Text = Core.class(Sprite)

function Tiled_Shape_Text:init(xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.text = xparams.text or nil
	params.ttf = xparams.ttf or nil
	params.color = xparams.color or nil
	params.r = xparams.r or 1
	params.g = xparams.g or 1
	params.b = xparams.b or 1
	params.alpha = xparams.alpha or 1
	params.scalex = xparams.scalex or 1
	params.scaley = xparams.scaley or params.scalex
	params.rotation = xparams.rotation or nil
	params.data = xparams.data or nil
	params.value = xparams.value or nil
	-- image
	local img = TextField.new(params.ttf, params.text, params.text)
--	img:setAnchorPoint(0, -1)
	if params.color then
		img:setTextColor(color)
	end
	img:setRotation(params.rotation)
	img:setAlpha(params.alpha)
	img:setColorTransform(params.r, params.g, params.b, params.alpha)
	-- auto scale
	local currw = img:getWidth()
	img:setScale(params.w/currw)
	--
--	self.w, self.h = img:getWidth(), img:getHeight()
	self:addChild(img)
end
