SCollision = Core.class()

function SCollision:init(xtiny, xbworld, xplayer1) -- tiny function
	xtiny.processingSystem(self) -- called once on init and every update
	self.bworld = xbworld
	self.player1 = xplayer1
	-- liquidfun listeners
	self.bworld:addEventListener(Event.BEGIN_CONTACT, self.onBeginContact, self)
	self.bworld:addEventListener(Event.END_CONTACT, self.onEndContact, self)
--	self.bworld:addEventListener(Event.PRE_SOLVE, self.onPreSolveContact, self)
--	self.bworld:addEventListener(Event.POST_SOLVE, self.onPostSolveContact, self)
end

function SCollision:filter(ent) -- tiny function
	return ent.body
end

function SCollision:onAdd(ent) -- tiny function
end

function SCollision:onRemove(ent) -- tiny function
end

function SCollision:process(ent, dt) -- tiny function
	ent.body.vx, ent.body.vy = ent.lf.body:getLinearVelocity()
	ent.body.desiredVelX, ent.body.desiredVelY = 0, 0
	ent.lf.body:setGravityScale(2) -- 1.3, 1.47, fine tune jump
	-- AIR fine tune jump
	if ent.lf.body.numfloorcontacts <= 0 then
		if ent.body.vy > 1 then ent.lf.body:setGravityScale(3) end -- 2, going down
	end
	-- countdowns
	if ent.body.currinputbuffer > 0 then -- floor input buffer
		ent.body.currinputbuffer -= 1
	end
	if ent.body.currdashtimer > 0 then -- dash
		ent.body.currdashtimer -= 1
	end
	if ent.body.currdashcooldown > 0 then -- dash cooldown
		ent.body.currdashcooldown -= 1
	end
	-- CONTROLS
	-- FLOOR ONLY
	-- ***********
	if ent.lf.body.numfloorcontacts > 0 then
		if ent.isleft and not ent.isright then -- LEFT
			ent.flip = -1
			if ent.body.currdashtimer > 0 then 
				ent.body.desiredVelX -= ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.desiredVelX = -ent.body.currspeed
			end
		elseif ent.isright and not ent.isleft then -- RIGHT
			ent.flip = 1
			if ent.body.currdashtimer > 0 then 
				ent.body.desiredVelX += ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.desiredVelX = ent.body.currspeed
			end
		else
			ent.body.desiredVelX = 0
		end
		if ent.body.currinputbuffer > 0 and not ent.isdown then -- UP
			ent.body.desiredVelY = -ent.body.currupspeed
			ent.body.currinputbuffer = 0 -- prevents constant jump on walls
		end
	-- AIR ONLY
	-- ********
	elseif ent.lf.body.numfloorcontacts <= 0 then
		if ent.isleft and not ent.isright then -- LEFT
			ent.flip = -1
			if ent.body.currdashtimer > 0 then 
				ent.body.desiredVelX -= ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.desiredVelX = -ent.body.currspeed
			end
		elseif ent.isright and not ent.isleft then -- RIGHT
			ent.flip = 1
			if ent.body.currdashtimer > 0 then 
				ent.body.desiredVelX += ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.desiredVelX = ent.body.currspeed
			end
		else
			ent.body.desiredVelX = 0
		end
	end
	-- final movements
	local velChange = ent.body.desiredVelX*dt - ent.body.vx
	local impulse = ent.lf.body:getMass()*velChange
	ent.lf.body:applyLinearImpulse(impulse, ent.body.desiredVelY, ent.lf.body:getWorldCenter())
	-- update sprite position and scale (facing)
	ent.sprite:setPosition(ent.lf.body:getPosition())
	ent.sprite:setScale(ent.sx*ent.flip, ent.sy)
end

-- liquidfun
function SCollision:onBeginContact(e)
	local fixtureA, fixtureB = e.fixtureA, e.fixtureB
	local bodyA, bodyB = fixtureA:getBody(), fixtureB:getBody()
	-- PLAYER1
	if (bodyA.role == G_PLAYER and bodyB.role == G_GROUND) or (bodyA.role == G_GROUND and bodyB.role == G_PLAYER) then
		if bodyA.role == G_PLAYER then
			bodyA.numfloorcontacts += 1
		else
			bodyB.numfloorcontacts += 1
		end
	end
end

function SCollision:onEndContact(e)
	local fixtureA, fixtureB = e.fixtureA, e.fixtureB
	local bodyA, bodyB = fixtureA:getBody(), fixtureB:getBody()
	-- PLAYER1
	if (bodyA.role == G_PLAYER and bodyB.role == G_GROUND) or (bodyA.role == G_GROUND and bodyB.role == G_PLAYER) then
		if bodyA.role == G_PLAYER then
			bodyA.numfloorcontacts -= 1
		else
			bodyB.numfloorcontacts -= 1
		end
	end
end

function SCollision:onPreSolveContact(e)
end

function SCollision:onPostSolveContact(e)
end
